package config

import (
	"os"
	"strings"

	log "github.com/sirupsen/logrus"

	"github.com/gofiber/fiber/v2"
	"github.com/spf13/viper"
)

const EnvPrefix = "ACMIN"

type DatabaseConfig struct {
	Driver       string
	DSN          string
	MaxLifetime  int    // 86400
	MaxIdleTime  int    // 3600
	MaxOpenConns int    // 100
	MaxIdleConns int    // 50
	TablePrefix  string // ""
	AutoMigrate  bool   // true
}

type AcminConfig struct {
	FiberConfig *fiber.Config  `yaml:"fiber"`
	Database    DatabaseConfig `yaml:"database"`
	Redis       RedisConfig
}

type RedisConfig struct {
	Addr     string
	DB       int
	Username string
	Password string
}

func InitFunc(configPath *string) func() {
	return func() {
		if *configPath != "" {
			if _, err := os.Stat(*configPath); err != nil {
				log.Errorf("stat: %s", err)
			}
			viper.SetConfigFile(*configPath)
		}

		viper.SetEnvPrefix(EnvPrefix)
		viper.SetEnvKeyReplacer(strings.NewReplacer(".", "_"))
		viper.AutomaticEnv()

		if err := viper.ReadInConfig(); err == nil {
			log.Debug("Using config file:", viper.ConfigFileUsed())
		}
	}
}
