package config

import (
	"os"
	"strings"
	"testing"

	"github.com/spf13/viper"
	"github.com/stretchr/testify/assert"
)

func TestConfig(t *testing.T) {
	ast := assert.New(t)

	envSet := []struct{ Key, Val string }{{"ACMIN_CONFIG", "test.yaml"}, {"ACMIN_REDIS_HOST", "localhost"}, {"ACMIN_REDIS_PORT", "6379"}}
	for i := range envSet {
		os.Setenv(envSet[i].Key, envSet[i].Val)
	}

	InitFunc(&envSet[0].Val)()

	for i := range envSet {
		result1 := viper.Get(strings.ToLower(strings.ReplaceAll(strings.TrimPrefix(envSet[i].Key, EnvPrefix+"_"), "_", ".")))
		ast.Equal(envSet[i].Val, result1)
		result2 := viper.Get(strings.TrimPrefix(envSet[i].Key, EnvPrefix+"_"))
		ast.Equal(envSet[i].Val, result2)
	}
}
