package context

import (
	log "github.com/sirupsen/logrus"
	"gitlab.xaotos.cn/qtt/acmin/internal/config"
	"gitlab.xaotos.cn/qtt/acmin/pkg/cache"
	"gorm.io/gorm"
)

type AppCtx struct {
	Conf  *config.AcminConfig
	Cache *cache.Cache
	DB    *gorm.DB
}

func New(cacher func() (
	*cache.Cache, error),
	dber func() (*gorm.DB, error),
	conf *config.AcminConfig) *AppCtx {
	cache, err := cacher()
	if err != nil {
		log.Fatal(err)
	}
	db, err := dber()
	if err != nil {
		log.Fatal(err)
	}
	return &AppCtx{
		Conf:  conf,
		Cache: cache,
		DB:    db,
	}
}
