package schema

import "time"

type Menu struct {
	ID          string    `json:"id" gorm:"size:20;primaryKey;"`
	Name        string    `json:"name"`
	Code        string    `json:"code"`
	Description string    `json:"description"`
	Path        string    `json:"path"`
	ParentID    string    `json:"parent"` // parent id
	ParentPath  string    `json:"parent_path"`
	Children    *Menus    `json:"children" gorm:"-"`        // sub level menus
	CreatedAt   time.Time `json:"created_at" gorm:"index;"` // Create time
	UpdatedAt   time.Time `json:"updated_at" gorm:"index;"` // Update time
}

type Menus []*Menu

func (ms Menus) TreeView() Menus {
	var root Menus
	// build graph
	m := map[string]*Menu{}
	for _, item := range ms {
		m[item.ID] = item
	}

	for _, item := range ms {
		if item.ParentID == "" { // root menu
			root = append(root, item)
		} else {
			// not root, append to parent menu
			p, ok := m[item.ParentID]
			if !ok {
				continue
			}
			*p.Children = append(*p.Children, item)
		}
	}
	return root
}
