package schema

import "time"

type User struct {
	ID        string    `json:"id" gorm:"size:20;primaryKey;"`
	Username  string    `json:"username" gorm:"size:64;index;"`
	Name      string    `json:"name" gorm:"size:64;index;"`
	Password  string    `json:"password" gorm:"size:256;"` // encrypt password with `algo` and `salt`
	Salt      string    `json:"salt" gorm:"size:8;"`       // random salt for encrypt password
	Algo      string    `json:"algo" gorm:"size:8;"`       // algo selected for encrypt password
	Phone     string    `json:"phone" gorm:"size:32;"`
	Email     string    `json:"email" gorm:"size:128;"`
	CreatedAt time.Time `json:"created_at" gorm:"index;"` // Create time
	UpdatedAt time.Time `json:"updated_at" gorm:"index;"` // Update time
	Roles     UserRoles `json:"roles" gorm:"-"`           // Roles of user
}

type UserRoles []UserRole
