package setup

import (
	"context"

	"github.com/gofiber/fiber/v2"
	"gitlab.xaotos.cn/qtt/acmin/internal/api"
)

// whole
type ServerConfig struct {
	FiberConfig fiber.Config `json:"fiber"`
	ListenAddr  string       `json:"listen_addr"`
}

func startHTTPServer(ctx context.Context, serverConfig ServerConfig) (*fiber.App, func() error, error) {
	app := fiber.New(serverConfig.FiberConfig)
	api.RegisterRouters(ctx, app)
	return app, nil, nil
}
