package cache

import (
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
)

type Foo struct {
	Bar string
}

func TestInMemoryCache(t *testing.T) {
	ast := assert.New(t)

	foo := Foo{"bar"}
	cache := NewInMemoryCache(time.Minute * 5)
	ast.Nil(cache.Set(&Item{Value: foo, Key: foo.Bar, Duration: time.Second * 60}))
	obj := new(Foo)
	ast.Nil(cache.Get(foo.Bar, obj))
	ast.Equal(obj.Bar, foo.Bar)
}
