package cache

import (
	"context"
	"testing"

	"github.com/alicebob/miniredis/v2"
	"github.com/redis/go-redis/v9"
	"github.com/stretchr/testify/assert"
)

func TestRedisCache(t *testing.T) {
	ast := assert.New(t)

	mr, err := miniredis.Run()
	ast.Nil(err)

	client := redis.NewClient(&redis.Options{
		Addr: mr.Addr(),
	})

	// ping test
	ast.Nil(client.Ping(context.TODO()).Err())
	//
	cache := NewRedisCache(client, 0, "")

	t.Run("Cache.Set", func(t *testing.T) {
		ast.Nil(cache.Set(&Item{Key: "testKey", Value: "test value"}))
	})

	t.Run("Cache.Get", func(t *testing.T) {
		var obj string
		ast.Nil(cache.Get("testKey", &obj))
		ast.Equal(obj, "test value")
	})

	t.Run("Cache.Delete", func(t *testing.T) {
		ast.Nil(cache.Delete("test key"))
	})
}
