package flag

import "github.com/spf13/cobra"

type Options struct {
	FlagPrefix string
}

func GetFlagVal[T any](cmd *cobra.Command, opt Options, name string, getVal func(name string) (T, error)) func() T {
	return func() T {
		var (
			res T
			err error
		)
		if opt.FlagPrefix != "" && cmd.Flags().Changed(opt.FlagPrefix+name) {
			res, err = getVal(opt.FlagPrefix + name)
		} else {
			res, err = getVal(name)
		}
		if err != nil {
			panic(err)
		}
		return res
	}
}
